﻿//////////////////////////////////////////////
// TextureUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Texture ;

	enum class TEXTURE_RENDER_FLAG ;
}

namespace nkImages
{
	enum class PIXEL_FORMAT ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Buffers/Enums/BufferBindFlag.h"

#include "../Dll/DllDefines.h"

#include "../Utils/DxDefinesWrapper.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT TextureUtils final
	{
		public :

			// Data on formats
			static unsigned int getFormatByteSize (FORMAT format) ;
			static unsigned int getFormatChannelCount (FORMAT format) ;
			static unsigned int getFormatPlaneCount (FORMAT format) ;
			static FORMAT getFormatSrgbEquivalent (FORMAT format) ;
			static FORMAT getFormatRgbEquivalent (FORMAT format) ;
			static FORMAT getFormatTypelessEquivalent (FORMAT format) ;
			static FORMAT getFormatDepthEquivalent (FORMAT format) ;
			static FORMAT getFormatUncompressedEquivalent (FORMAT format) ;
			static FORMAT getFormatWithAlphaEquivalent (FORMAT format) ;

			static bool isFormatOver255 (FORMAT format) ;
			static bool isFormatCompressed (FORMAT format) ;
			static bool isFormatCompatibleWithStencil (FORMAT format) ;
			static bool isFormatCompatibleForRenderFlag (FORMAT format, TEXTURE_RENDER_FLAG renderFlag, BUFFER_BIND_FLAG bindFlag) ;

			// Infos mips
			static int getNeededMipsForSize (int width, int height, int depthOrArraySize, bool texArray) ;

			// nkImages interop
			static FORMAT getFormatFromImageFormat (nkImages::PIXEL_FORMAT format) ;
	} ;
}
